#include <stdlib.h>
#include "pages.h"
#include "blocks.h"
#include "cast.h"

extern struct s_page *g_page;

/*
** Marks the block as used and eventually creates a new free block
*/
void *usedata(struct s_page *bpage, struct s_block *block, size_t size)
{
    struct s_block *new = NULL;
    block->isfree = 0;
    bpage->av_size -= size;
    if (block->size - size <= sizeof (struct s_block))
        return blockdata(block); /* Not enough space to add more blocks */
    /* Create new block with available size */
    new = tovoid(tobyte(block + 1) + size);
    size_t added_space = block->size - size - sizeof (struct s_block);
    new->size = added_space;
    bpage->av_size += added_space;
    block->size = size;
    new->prev = block;
    new->next = block->next;
    block->next = new;
    new->isfree = 1;
    if (new->next)
        new->next->prev = new;
    return blockdata(block);
}

void *best_match(size_t size)
{
    struct s_page  *it = g_page;
    struct s_block *match = NULL;
    struct s_block *b = NULL;
    struct s_page  *matchp = g_page;
    while (it)
    {
        b = firstblock(it);
        while (b && it->av_size >= size)
        {
            if (b->isfree && b->size == size)
                return usedata(it, b, size);
            if (b->isfree && b->size > size)
                if (!match || (match && match->size >= b->size))
                {
                    match = b;
                    matchp = it;
                }
            b = b->next;
        }
        it = it->next;
    }
    if (!match) /* not enough space in mapped pages */
        return NULL;
    return usedata(matchp, match, size);
}
