#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include "cast.h"
#include "pages.h"
#include "blocks.h"
#include "allocate.h"

#define _GNU_SOURCE

struct s_page *g_page = NULL; /* Containing fisrt page position */

void *calloc(size_t nmemb, size_t size)
{
    void *ptr = malloc(nmemb * size);
    if (!ptr)
        return NULL;
    struct s_block *curr = tovoid(tobyte(ptr) - sizeof (struct s_block));
    for (size_t i = 0; i < curr->size; i++)
        *(tobyte(ptr) + i) = 0;
    return ptr;
}

static void my_memcpy(void *from, void *to)
{
    struct s_block *curr = tovoid(tobyte(from) - sizeof (struct s_block));
    char *dest = to;
    char *src = from;
    for (size_t i = 0; i < curr->size; i++)
        dest[i] = src[i];
}

void *realloc(void *ptr, size_t size)
{
    struct s_block *curr = tovoid(tobyte(ptr) - sizeof (struct s_block));
    if (!size)
        free(ptr);
    if (!size)
        return ptr;
    if (!ptr)
        return malloc(size);
    if (curr->size >= size)
        return ptr;
    /* block after current can handle the realloc'd data */
    if (curr->next &&
        curr->next->isfree &&
        size - curr->size - sizeof (struct s_block) <= curr->next->size)
    {
        getpage(curr)->av_size += sizeof (struct s_block) + curr->size;
        curr->size += sizeof (struct s_block) + curr->next->size;
        return usedata(getpage(curr), curr, align(size));
    }
    void *new = malloc(size);
    if (!new)
        return NULL;
    my_memcpy(ptr, new);
    free(ptr);
    return new;
}

void *malloc(size_t size)
{
    if (!size)
        return NULL;
    void *ptr = NULL;
    if (!g_page) /* first malloc */
    {
        if (!(g_page = newpage(size, NULL)))
            return NULL;
        return usedata(g_page, firstblock(g_page), align(size));
    }
    if (!(ptr = best_match(align(size))))
    {
        if (!add_page(size))
            return NULL;
        ptr = best_match(align(size));
    }
    return ptr;
}

static void *free_around(struct s_page *update, struct s_block *curr)
{
    while ((curr->prev && curr->prev->isfree) ||
           (curr->next && curr->next->isfree))
    {
        if (curr->next && curr->next->isfree)
        {
            curr = curr->next;
            continue;
        }
        update->av_size += sizeof (struct s_block);
        curr->prev->size += sizeof (struct s_block) + curr->size;
        curr->prev->next = curr->next;
        if (curr->next)
            curr->next->prev = curr->prev;
        curr->next = NULL;
        curr = curr->prev;
    }
    return curr;
}

static unsigned pagesize()
{
    long len = sysconf(_SC_PAGESIZE);
    len -= sizeof (struct s_page) + sizeof (struct s_block);
    return len;
}

void free(void *ptr)
{
    if (!ptr)
        return;
    struct s_block *curr = tovoid(tobyte(ptr) - sizeof (struct s_block));
    struct s_page *update = getpage(curr);
    curr->isfree = 1;
    update->av_size += curr->size;
    curr = free_around(update, curr);
    if (update->av_size >= pagesize() || (curr->next == curr->prev))
    {
        struct s_page *prev = update->prev;
        if (update == g_page)
            g_page = NULL;
        if (prev)
            prev->next = NULL;
        munmap(update, sysconf(_SC_PAGESIZE));
    }
}
