#define _GNU_SOURCE
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include "blocks.h"
#include "pages.h"
#include "cast.h"

extern struct s_page *g_page;

struct s_page *newpage(size_t size, struct s_page *parent)
{
    size_t total_size = size + sizeof (struct s_page) + sizeof (struct s_page);
    size_t plen = sysconf(_SC_PAGESIZE);

    if (total_size > plen)
        plen = align(total_size);
    struct s_page *new = mmap(NULL,
            plen,
            PROT_READ | PROT_WRITE,
            MAP_PRIVATE | MAP_ANONYMOUS,
            -1,
            0);
    if (!new)
        return NULL;
    new->av_size = plen - sizeof (struct s_page) - sizeof (struct s_block);
    new->next = NULL;
    new->prev = parent;
    struct s_block *fblock = firstblock(new);
    fblock->size = plen - sizeof (struct s_page) - sizeof (struct s_block);
    fblock->isfree = 1;
    fblock->next = NULL;
    fblock->prev = NULL;
    return new;
}

int add_page(size_t size)
{
    struct s_page *it = g_page;

    while (it->next)
        it = it->next;

    it->next = newpage(size, it);
    return it->next != NULL;
}

struct s_block *firstblock(struct s_page *this)
{
    return tovoid(++this);
}

struct s_page *getpage(struct s_block *block)
{
    struct s_block *it = block;
    while (it->prev)
        it = it->prev;
    return tovoid(tobyte(it) - sizeof (struct s_page));
}

size_t align(size_t n)
{
    if (!(n % 8))
        return n;

    size_t i = 0;
    for (; i < n; i += 8)
        continue;

    return i;
}
