#ifndef PAGES_H
# define PAGES_H

# include "blocks.h"

struct s_page
{
    size_t av_size;
    struct s_page *next;
    struct s_page *prev;
} __attribute__ ((packed));

/**
** @brief Maps new page in memory and returns a pointer to formatted data area
**
** Maps a new page of sysconf(SC_PAGESIZE) size or align size on size_t if it's
** too big for regular page and maps a page of aligned total size.
** It initialize a new page at the beggining of the mapped memory and a new
** empty block right after it.
** @param size Size of the data needed to be allocated
** @param parent Pointer to page previously allocated or NULL if none
** @return Returns the page newly allocated
*/
struct s_page *newpage(size_t size, struct s_page *p);

/**
** @brief Adds a page of at least given size
**
** @param size The size needed to be allocated
** @return 1 on success and 0 on failure
*/
int add_page(size_t size);

/**
** @brief Gets the first block of a page
**
** @param p The page to look in
** @return first block of given page
*/
struct s_block *firstblock(struct s_page *p);

/**
** @brief Retrieves page of given block
**
** @param block The block from which to start searching
** @return The parent page of given block
*/
struct s_page *getpage(struct s_block *block);
size_t align(size_t size);
#endif /* !PAGES_H */
