import ConfigParser

def OptionIsSet(cfg, name, key):
    return cfg.has_option(name, key) and cfg.get(name, key)

def getKeyIfExists(cfg, name, key):
    if cfg.has_option(name, key):
        return cfg.get(name, key).decode('utf-8')
    else:
        return None

def stripAllLines(string):
    return '\n'.join([s.strip() for s in string.split('\n')])
