#coding: utf-8
import sys
from string import Template
from TestSuite import notice
from TestSuite.args import *
from TestSuite import term
from TestSuite.category import TestCategory
from TestSuite.test import Test

class TermOutput:
    def __init__(self, fout = None):
        self.indent = ''
        self._incind = 2 * ' '
        self.fout = fout
        self.passed = term.format('Success', term.bold, term.green)
        self.warn = term.format('-Warning-', term.bold, term.yellow)
        self.failed = term.format('Failed', term.bold, term.red)

    # functions for indentation
    def incindent(self, i=1):
        self.indent += i * self._incind
        return self.indent[:-1]
    def decindent(self, i=1):
        self.indent = self.indent[:-(i * len(self._incind))]

    def _write(self, string):
        sys.stdout.write(string)
        sys.stdout.flush()

    def _getwarn(self, key):
        if notice.Notices.notices.has_key(key) and notice.Notices.notices[key] != notice.info:
            return ' ' + self.warn
        else:
            if isinstance(key, Test):
                return ' ' + self.warn if key.isWarning() else ''
            return ''

    def writeCategory(self, cat, isLast = False):
        template = Template("- {$name} ($total item$plurial)$warn\n")
        vals = {'name':term.format(str(cat), term.bold, term.blue),
                'total':str(len(cat)),
                'plurial':'s' if len(cat) > 1 else '',
                'warn': self._getwarn(cat)}
        self._write(self.indent + template.substitute(vals))

    def writeTestCategory(self, cat, isLast = False):
        template = Template("- {$name} ($total item$plurial)$warn\n")
        vals = {'name':term.format(str(cat), term.bold, term.cyan),
                'total':str(len(cat)),
                'plurial':'s' if len(cat) > 1 else '',
                'warn': self._getwarn(cat)}
        self._write(self.indent + template.substitute(vals))


    def writeTest(self, test, writeAll = True, isLast = False):
        if writeAll:
            template = Template("- [$name]: $result$warn\n")
            vals = {'name':term.format(str(test), term.bold),
                    'result':self.passed if test else self.failed,
                    'warn': self._getwarn(test)}
            self._write(self.indent + template.substitute(vals))
        else:
            self._write(self.indent + "- [%s]: " % test.name)

    def writeTestResults(self, test, isLast = False):
        passed = self.passed if test else self.failed
        if test.isWarning():
            passed += ' ' + self.warn
        self._write(passed)
        self._write('\n')

    def writeResults(self, cat):
        if not len(cat):
            return
        passed = cat.success()
        failed = len(cat) - cat.success()
        template = Template("- end of {$name} ($total item$plurial, $passed passed, $failed failed)\n")
        vals = {'name':term.format(cat.name, term.bold, term.cyan if isinstance(cat, TestCategory) else term.blue),
                'total':str(len(cat)),
                'plurial':'s' if len(cat) > 1 else '',
                'passed':str(passed),
                'failed':str(failed)}
        self._write(self.indent + template.substitute(vals))
