import argparse

def _getArgs():
    parser = argparse.ArgumentParser(description="Outputes the result of all tests located in the `tests' directory to standard output")
    parser.add_argument('-c',
        '--categories',
        action="store_true",
        help="display the categories and the percentage of successful tests for each of these categories without displaying the related tests.",
        required=False)
    #FIXME
#    parser.add_argument('-e',
#        '--select',
#        action='append',
#        type=str,
#        help="execute the test suite on the CATEGORY passed in argument only (to pass more than one category, use this option several times)",
#        metavar="CATEGORY",
#        nargs='*',
#        required=False)
#    parser.add_argument('-a',
#        '--all', 
#        action="store_true",
#        help="execute the test suite on all categories (default option if none is given during the call)",
#        required=False)
    parser.add_argument('-t',
        '--time',
        type=float,
        help="set TIME as a general timeout time for all tests (in seconds)",
        required=False)
#FIXME
#    parser.add_argument('-g',
#        '--generate',
#        action="store_true",
#        help="Generate a test file from stdin",
#        required=False)
    parser.add_argument('-o',
        '--output',
        help="Repertory to save output to",
        required=False)
    parser.add_argument('-B',
        '--before',
        help="Run a shell init script before starting to run tests",
        required=False)
    parser.add_argument('-b',
            '--basedir',
            metavar="BASEDIR",
            help="Base directory for tests",
            required=False)

    return vars(parser.parse_args())

class ArgsStore(object):
    args = _getArgs()
    #all = args['all']
    #ordered = args['ordered']
    #categories = args['categories']
    time = args['time']
    output = args['output'] if args['output'] else None
    basedir = args['basedir'] if args['basedir'] else None
    #generate = args['generate']
    #select = args['select']
