from TestSuite import args
from TestSuite import notice
from TestSuite import test
from TestSuite import term
import ConfigParser
import os
import sys

# represents a .test file
class TestCategory:
    def __init__(self, name, path):
        self.tests = []
        self.name = name[:-5] # remove '.test'
        self.path = path
        self.config = ConfigParser.ConfigParser()
        self.config.read(os.path.join(path, name))
        for testname in self.config.sections():
            if self.config.has_option(testname, 'cmd'):
                self.tests.append(test.Test(testname, self.config, self))
            else:
                try:
                    error = self.config.get(testname, 'cmd')
                except Exception as e:
                    print term.format("In file %s:" % os.path.join(path, name), term.bold, term.red)
                    print term.format(e, term.bold, term.red)
                    sys.exit(1)

    def __str__(self):
        return self.name

    def __len__(self):
        return len(self.tests)

    def __nonzero__(self):
        return self.success() == len(self.tests)

    def success(self):
        count = 0
        for t in self.tests:
            if t: count += 1
        return count

    def run(self, displayers = []):
        for display in displayers:
            display.writeTestCategory(self)
            display.incindent()

        for test in self.tests:
            for display in displayers:
                display.writeTest(test, writeAll = False, isLast = self.tests.index(test) == len(self.tests) - 1)
            test.run()
            for display in displayers:
                display.writeTestResults(test)

        for display in displayers:
            display.decindent()
            display.writeResults(self)

class Category:
    def __init__(self, name, path):
        self.testcategories = []
        self.subcategories = []
        self.name = name
        self.path = os.path.join(path, name)
        self.order = self._getorder()
        for f in os.listdir(self.path):
            examined = os.path.join(self.path, f)
            if os.path.isdir(examined) and not f.startswith('.'):
                self.subcategories.append(Category(f, self.path))
            elif f.endswith('.test') and not f.startswith('.'):
                self.testcategories.append(TestCategory(f, self.path))
            else:
                pass

    def _getorder(self):
        fname = '.order'
        if not os.path.isfile(os.path.join(self.path, fname)):
            return []
        else:
            return [line.strip() for line in file(os.path.join(self.path, fname), 'r').readlines()]

    def __str__(self):
        return self.name

    def __len__(self):
        return len(self.testcategories) + len(self.subcategories)

    def __nonzero__(self):
        return self.success() == len(self)

    def success(self):
        count = 0
        for tc in self.testcategories:
            if tc: count += 1
        for sc in self.subcategories:
            if sc: count += 1
        return count

    def run(self, displayers=[]):
        it = 0
        ic = 0
        for i in xrange(len(self.order)):
            if self.order[i] in [str(n) for n in self.testcategories]:
                index = [str(n) for n in self.testcategories].index(self.order[i])
                # swapping categories in list
                self.testcategories[index], self.testcategories[it] = self.testcategories[it], self.testcategories[index]
                it += 1
            elif self.order[i] in [str(n) for n in self.subcategories]:
                index = [str(n) for n in self.subcategories].index(self.order[i])
                self.subcategories[ic], self.subcategories[index] = self.subcategories[index], self.subcategories[ic]
                ic += 1

        for display in displayers:
            display.writeCategory(self)
            display.incindent()

        for testcat in self.testcategories:
            testcat.run(displayers)
        for subcat in self.subcategories:
            subcat.run(displayers)

        for display in displayers:
            display.decindent()
            display.writeResults(self)
