import subprocess
import threading
import os
from TestSuite import utils
from TestSuite.args import ArgsStore

DEFAULT_CWD = os.getcwd()

class Runnable:
    def __init__(self, cmd, stdin='', time=0, path=DEFAULT_CWD, file_out=None):
        self.cmd = cmd
        self.stdin = stdin
        self.time = time
        self.thread = threading.Thread(target = self._run)

        self.stdout = None
        self.stderr = None
        self.pid = None
        self.path = ArgsStore.basedir if ArgsStore.basedir else path

        self.fout = None
        if file_out is not None:
            self.fout = file(file_out, 'w')
        if self.stdin:
            self.stdin = self.stdin.encode('utf-8')

    def _run(self):
        self.pid = subprocess.Popen(self.cmd, shell=True, cwd=self.path ,stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        self.stdout, self.stderr = self.pid.communicate(self.stdin)
        if self.stdin:
            self.stdin = self.stdin.decode('utf-8')
        self.stdout = utils.strip_lines(self.stdout.decode('utf-8'))
        self.stderr = utils.strip_lines(self.stderr.decode('utf-8'))
        if self.fout:
            self.fout.write(self.stdout)
            self.fout.close()

    def terminate(self):
        if self.pid:
                self.pid.kill()
                self.pid.terminate()

    def run(self):
        self.thread.start()
        self.thread.join(self.time)
        if self.thread.is_alive():
            self.terminate()
            self.thread.join()
            return True
        return False

    def has_warning(self):
        return self.stderr or self.pid.returncode
